VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCaseConverter"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Enumeration to force different styles of processing.
Public Enum eStyle
    styUCase = 0
    styLCase = 1
    styRCase = 2
End Enum

'Integer variable stores the Enum style for the different
'processing tasks.
Private mintStyle As Integer
Private mstrCasedString As String

Public Property Get Style() As eStyle
    Style = mintStyle
End Property

Public Property Let Style(ByVal NewValue As eStyle)
    mintStyle = NewValue
End Property

Public Sub ProcessCase(SelectedText As String)
    'Decide which style to process depending on the value
    'stored in mintStyle.
    Select Case mintStyle
        Case 0
            mstrCasedString = ForceUpperCase(SelectedText)
        Case 1
            mstrCasedString = ForceLowerCase(SelectedText)
        Case 2
            mstrCasedString = ForceRandomCase(SelectedText)
    End Select
End Sub

Private Function ForceUpperCase(SelectedText As String) As String
    'Force to upper case.
    ForceUpperCase = UCase(SelectedText)
End Function

Private Function ForceLowerCase(SelectedText As String) As String
    'Force to Lower case.
    ForceLowerCase = LCase$(SelectedText)
End Function

Private Function ForceRandomCase(SelectedText As String) As String
    Dim intCount As Integer
    Dim intCase As Integer
    Dim strChar As String
    
    'Randomly decide whether to force UCase or LCase.
    intCount = 1
    Do While intCount < Len(SelectedText)
        intCase = (Int((2 * Rnd) + 1))
        strChar = (Mid(SelectedText, intCount, 1))
        Select Case intCase
            Case 1
                SelectedText = Replace(SelectedText, strChar, UCase$(strChar), , 1)
            Case 2
                SelectedText = Replace(SelectedText, strChar, LCase$(strChar), , 1)
        End Select
        intCount = intCount + 1
    Loop
    ForceRandomCase = SelectedText
End Function

Public Property Get ReturnedString() As String
    ReturnedString = mstrCasedString
End Property

