VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFlood"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Enum specifies the flood type.
Public Enum eFloodType
    flTextOnly = 0
    flImageOnly = 1
    flTextAndImage = 2
End Enum

'Specifies how images are flooded on the screen... random or
'has a selected image been specified.
Public Enum eFloodImages
    flSelected = 0
    flRandom = 1
End Enum

Private intType As Integer              'Type of flood.
Private intHowImageFlooded As Integer   'How are the images flooded (Random or specific).
Private strFloodText As String          'Flood text.
Private strFloodImage As String         'Flood image if selected.
Private strNoOfTimes As String          'No of times.
Private strNoOfImagesBetween As String  'No of images between for image and text flood.
Private strArrayOfImages(47) As String  'Array of hard coded images.

Public Property Get FloodType() As eFloodType
    FloodType = intType
End Property

Public Property Let FloodType(ByVal NewValue As eFloodType)
    intType = NewValue
End Property

Public Property Get HowIsImageFlooded() As eFloodImages
    HowIsImageFlooded = intHowImageFlooded
End Property

Public Property Let HowIsImageFlooded(ByVal NewValue As eFloodImages)
    intHowImageFlooded = NewValue
End Property

Public Property Get FloodText() As String
    FloodText = strFloodText
End Property

Public Property Let FloodText(ByVal NewValue As String)
    strFloodText = NewValue
End Property

Public Property Get FloodImage() As String
    FloodImage = strFloodImage
End Property

Public Property Let FloodImage(ByVal NewValue As String)
    strFloodImage = NewValue
End Property

Public Property Get NoOfTimes() As String
    NoOfTimes = strNoOfTimes
End Property

Public Property Let NoOfTimes(ByVal NewValue As String)
    If CInt(NewValue) <= 1 Then
        strNoOfTimes = "1"
    Else
        strNoOfTimes = NewValue
    End If
End Property

Public Property Get NoOfImagesBetween() As String
    NoOfImagesBetween = strNoOfImagesBetween
End Property

Public Property Let NoOfImagesBetween(ByVal NewValue As String)
    If CInt(NewValue) < 1 Then
        strNoOfImagesBetween = "1"
    Else
        strNoOfImagesBetween = NewValue
    End If
End Property

Private Sub Class_Initialize()
    'Load all images into the array strArrayOfImages.
    strArrayOfImages(0) = "Aspirin"
    strArrayOfImages(1) = "Ball"
    strArrayOfImages(2) = "Beer"
    strArrayOfImages(3) = "Briefcase"
    strArrayOfImages(4) = "Check"
    strArrayOfImages(5) = "Cigar"
    strArrayOfImages(6) = "Clover"
    strArrayOfImages(7) = "Clover"
    strArrayOfImages(8) = "Coffee"
    strArrayOfImages(9) = "Crybaby"
    strArrayOfImages(10) = "Depressed"
    strArrayOfImages(11) = "Dice"
    strArrayOfImages(12) = "Exclaim"
    strArrayOfImages(13) = "File"
    strArrayOfImages(14) = "First"
    strArrayOfImages(15) = "Floppy"
    strArrayOfImages(16) = "Frowny"
    strArrayOfImages(17) = "Gavel"
    strArrayOfImages(18) = "Greenlight"
    strArrayOfImages(19) = "Haha"
    strArrayOfImages(20) = "Handshake"
    strArrayOfImages(21) = "Happycomp"
    strArrayOfImages(22) = "Heart"
    strArrayOfImages(23) = "Idea"
    strArrayOfImages(24) = "Inbox"
    strArrayOfImages(25) = "Kaboom"
    strArrayOfImages(26) = "Lips"
    strArrayOfImages(27) = "Mail"
    strArrayOfImages(28) = "Megafone"
    strArrayOfImages(29) = "Money"
    strArrayOfImages(30) = "Music"
    strArrayOfImages(31) = "Ohno"
    strArrayOfImages(32) = "Outbox"
    strArrayOfImages(33) = "Peace"
    strArrayOfImages(34) = "Phone"
    strArrayOfImages(35) = "Pinkslip"
    strArrayOfImages(36) = "Profitdown"
    strArrayOfImages(37) = "Profitup"
    strArrayOfImages(38) = "Pushpin"
    strArrayOfImages(39) = "Question"
    strArrayOfImages(40) = "Rose"
    strArrayOfImages(41) = "Sadcomp"
    strArrayOfImages(42) = "Smiley"
    strArrayOfImages(43) = "Teddybear"
    strArrayOfImages(44) = "Thumbsdown"
    strArrayOfImages(45) = "Trash"
    strArrayOfImages(46) = "Watercooler"
    strArrayOfImages(47) = "Winking"
End Sub


Public Function CreateFlood() As String
    'Main public method that deals with the
    'flooding.  Decide how you'd like to flood by
    'looking at the type enum and deciding in code.
    Select Case intType
        Case flTextOnly
            CreateFlood = Trim(CreateTextFloodOnly)
        Case flImageOnly
            Select Case intHowImageFlooded
                Case flSelected
                    CreateFlood = Trim(CreateSelectedImageFlood)
                Case flRandom
                    CreateFlood = Trim(CreateRandomImageFlood)
            End Select
        Case flTextAndImage
            Select Case intHowImageFlooded
                Case flSelected
                    CreateFlood = Trim(CreateSelectedImageAndTextFlood)
                Case flRandom
                    CreateFlood = Trim(CreateRandomImageAndTextFlood)
            End Select
    End Select
End Function

Private Function CreateTextFloodOnly() As String
    'Flood with text only.  Using strNoOfTimes convert
    'it to an integer and use it to loop and add the
    'string to itself for the number of times that you
    'request (intNum)
    Dim intNum As Integer
    Dim iCount As Integer
    Dim strRep
    intNum = CInt(strNoOfTimes)
    
    For iCount = 0 To intNum - 1
        strRep = strRep & " " & strFloodText
    Next
    CreateTextFloodOnly = strRep
End Function

Private Function CreateSelectedImageFlood() As String
    'Add the "//" to the string and then add it to itself
    ' the amount of times requested.
    Dim strImg As String
    Dim strFormattedImage As String
    Dim intNo As String
    Dim iCnt As Integer
    
    strFormattedImage = "//" & strFloodImage
    intNo = CInt(strNoOfTimes)
    
    For iCnt = 0 To intNo - 1
        strImg = strImg & " " & strFormattedImage
    Next
    CreateSelectedImageFlood = strImg
End Function

Private Function CreateRandomImageFlood()
    Dim imgNum As Integer
    Dim iCnt As Integer
    Dim intNo As Integer
    Dim strImgText As String
    Dim strImgFlood As String
    
    intNo = CInt(strNoOfTimes)
    For iCnt = 0 To intNo - 1
    
        'Create a random number from a selection
        'of 1 to 48. Then decrement the value by
        'one so that i never reaches 48 and might
        'have a value of zero.
        imgNum = (Int((48 * Rnd) + 1))
        imgNum = imgNum - 1
        
        strImgText = " //" & strArrayOfImages(imgNum)
        strImgFlood = strImgFlood & strImgText
        
    Next
    
    CreateRandomImageFlood = strImgFlood
        
End Function

Private Function CreateSelectedImageAndTextFlood()
    Dim iCount As Integer, Img As String
    Dim Txt As String, ImgString As String
    Dim strFlood As String, MergeCnt As Integer
    Dim intFloodCnt As Integer
    
    Img = " //" & strFloodImage 'Flood image property value
    Txt = " " & strFloodText  'Flood text property value.
    'How many images to merge between text.
    MergeCnt = CInt(strNoOfImagesBetween) 'ie. //image (MergeCnt) Text //Image (MergeCnt)
    intFloodCnt = CInt(strNoOfTimes)
    
    'Now set up the amount of images to string inbetween
    'the text.
    For iCount = 0 To MergeCnt - 1
        ImgString = ImgString & Img
    Next
    'Now set up the flood.
    For iCount = 0 To intFloodCnt - 1
        strFlood = strFlood & ImgString & Txt
    Next
    strFlood = strFlood & ImgString
    
    CreateSelectedImageAndTextFlood = strFlood
End Function

Private Function CreateRandomImageAndTextFlood()
    Dim iCount As Integer
    Dim iCount2 As Integer
    Dim intFloodCnt As Integer
    Dim imgNum As Integer
    Dim MergeCnt As Integer
    Dim TempString As String    'Stores temporary image string.
    Dim ImgString As String
    Dim Txt As String
    Dim strFlood As String
    Dim strImg As String
    
    Txt = strFloodText
    Txt = " " & Txt
    intFloodCnt = CInt(strNoOfTimes)
    MergeCnt = CInt(strNoOfImagesBetween)
       
    For iCount = 0 To intFloodCnt - 1
        For iCount2 = 0 To MergeCnt - 1
            imgNum = (Int((48 * Rnd) + 1))
            imgNum = imgNum - 1
            strImg = " //" & strArrayOfImages(imgNum)
            ImgString = ImgString & strImg
        Next
        strFlood = strFlood & ImgString & Txt
        ImgString = ""
    Next
    For iCount2 = 0 To MergeCnt - 1
        imgNum = (Int((48 * Rnd) + 1))
        imgNum = imgNum - 1
        strImg = " //" & strArrayOfImages(imgNum)
        ImgString = ImgString & strImg
    Next
    strFlood = strFlood & ImgString
    
    CreateRandomImageAndTextFlood = strFlood
End Function
