Attribute VB_Name = "modMain"
Option Explicit

Public Type PersonalStuff
    Caption As String
    Info As String
End Type

Public Type UserAccounts
    AccountName As String
    UserName As String
    UserPass As String
End Type

Public Type ChatRoom
    Name As String
    URL As String
End Type

'The following is the API declaration to open Microsoft Internet Explorer
'Browser or Microsoft Outlook Express
Declare Function ShellExecute Lib "shell32.dll" _
Alias "ShellExecuteA" _
(ByVal hwnd As Long, ByVal IpOperation As String, _
ByVal IpFile As String, ByVal IpParameters As String, _
ByVal IpDirectory As String, ByVal nShowCmd As Long) _
As Long

Public arrPersonal(14) As PersonalStuff
Public arrBoot(14) As String
Public arrChatURL(10) As ChatRoom
Public arrImages(46) As String
Public RandomImages() As String
Public arrAccounts(14) As UserAccounts


Public Sub GetInfo()
    'Load file into arrays so that the program
    'can use the data.
    Dim x As Integer    'Count through.
    
    On Error Resume Next
    MkDir (App.Path & "\Data\")
    Open App.Path & "\Data\CutPaste.zrz" For Input As #1
    For x = 0 To UBound(arrPersonal)
        Input #1, arrPersonal(x).Caption
        Input #1, arrPersonal(x).Info
    Next
    For x = 0 To UBound(arrBoot)
        Input #1, arrBoot(x)
    Next
    For x = 0 To UBound(arrChatURL)
        Input #1, arrChatURL(x).Name
        Input #1, arrChatURL(x).URL
    Next
    For x = 0 To UBound(arrImages)
        Input #1, arrImages(x)
    Next
    For x = 0 To UBound(arrAccounts)
        Input #1, arrAccounts(x).AccountName
        Input #1, arrAccounts(x).UserName
        Input #1, arrAccounts(x).UserPass
    Next
    Close
    SetAttr App.Path & "\Data\CutPaste.zrz", vbHidden
End Sub

Public Sub SaveInfo()
    Dim x As Integer
    'Save new information.
    On Error GoTo SaveError
    Open App.Path & "\Data\CutPaste.zrz" For Output As #1
    With frmData
        For x = 0 To UBound(arrPersonal)
            Print #1, Trim(.txtPersonalCaption(x).Text)
            Print #1, Trim(.txtPersonalData(x).Text)
        Next
        For x = 0 To UBound(arrBoot)
            Print #1, Trim(.txtBoot(x).Text)
        Next
        For x = 0 To UBound(arrChatURL)
            Print #1, Trim(.txtRoomName(x).Text)
            Print #1, Trim(.txtChatURL(x).Text)
        Next
        For x = 0 To UBound(arrImages)
            Print #1, Trim(.txtImage(x).Text)
        Next
        For x = 0 To UBound(arrAccounts)
            Print #1, Trim(.txtUserAccount(x).Text)
            Print #1, Trim(.txtUserName(x).Text)
            Print #1, Trim(.txtPassword(x).Text)
        Next
    End With
    Close
    Exit Sub
SaveError:
    MsgBox "error" & Err.Number & " " & Err.Description
End Sub

Public Sub PopulateDataForm()
    Dim x As Integer
    'Show the information on the form at startup.
    With frmData
        For x = 0 To UBound(arrPersonal)
            .txtPersonalCaption(x) = arrPersonal(x).Caption
            .txtPersonalData(x) = arrPersonal(x).Info
        Next
        For x = 0 To UBound(arrBoot)
            .txtBoot(x) = arrBoot(x)
        Next
        For x = 0 To UBound(arrChatURL)
            .txtRoomName(x) = arrChatURL(x).Name
            .txtChatURL(x) = arrChatURL(x).URL
        Next
        For x = 0 To UBound(arrImages)
            .txtImage(x) = arrImages(x)
        Next
        For x = 0 To UBound(arrAccounts)
            .txtUserAccount(x) = arrAccounts(x).AccountName
            .txtUserName(x) = arrAccounts(x).UserName
            .txtPassword(x) = arrAccounts(x).UserPass
        Next
    End With
End Sub

Public Function GetAboutText() As String
    Dim strMes As String
    
    strMes = "The Chat Gladiator was developed by Cygnus x1 for easier " & _
    "chat access, and to eliminate some of the tedious procedures. " & _
    "Sometimes you just can't remember everything, and sometimes you just " & _
    "need to be able to do something better an more efficiently than the " & _
    "next guy. " & vbCrLf & vbCrLf & _
    "Ever been troubled by irritating people in chat? I have... so you need " & _
    "to have some method of showing them that you really don't care to be " & _
    "harrassed. So apart from some of the more elementary stuff, there are " & _
    "a few small chat weapons as well, just thrown in for your own use. " & _
    vbCrLf & vbCrLf & _
    "Cygnus x1 does have a web site that you can go visit at " & _
    "www.crosswinds.net/~cygster" & vbCrLf & _
    "My alternate email address is astral_blizzard@hotmail.com"
    
    GetAboutText = strMes
End Function
