VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSaveLoad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private arrLetter As String
Private arrNumber As String

Private Sub LoadGame()
    Dim ClCount As Integer
    Dim i As Integer
    Dim x As Integer
    Dim j As Integer
    Dim FileNum As Long
    Dim imgCnt As Integer
    Dim YourMove As String
    'The following variables store and sort through the
    'text position, and piece entries.
    Dim SquTag As String
    Dim SquWha As String
    Dim ImgTag As String
    Dim InpStr As String
    
    With frmChessBoard
        'Clear all the pieces of the squares on the chess
        'board.
        For ClCount = 0 To .Square.Count - 1
            .Square(ClCount).Picture = Nothing
        Next
        'This opens the common dialog control and shows you
        'all the game files that you've saved.
        With .CommonDialog1
            .Filter = "Net Chess Saved Games (*.CHS)|*.CHS"
            .DialogTitle = "Save current game"
            .InitDir = App.Path
            .ShowOpen
            If .FileName = "" Then Exit Sub
        End With
        'Open and read the values of the numbers and letters
        'into the applicable board labels.
        FileNum = FreeFile
        On Error GoTo handleit
        Open .CommonDialog1.FileName For Input As FileNum
            Input #FileNum, YourMove
            'Show who's move it is
            If YourMove = "y" Then
                .MakeChatRoomText etypalertmessage, "You to move first"
            Else
                .MakeChatRoomText etypalertmessage, "Opponent's move first"
            End If
            'Print out chessboard letter positions.
            For i = 0 To .lblLetter.Count - 1
                Input #FileNum, arrLetter
                .lblLetter(i).Caption = arrLetter
            Next
            For i = 0 To .lblLeftNum.Count - 1
                Input #FileNum, arrNumber
                .lblLeftNum(i).Caption = arrNumber
            Next
            'Load in the square values: WhatsThisHelpID and
            'Tag properties.
            For i = 0 To .Square.Count - 1
                Input #FileNum, InpStr
                SquTag = Left(InpStr, 1)
                SquWha = Mid(InpStr, 2)
                .Square(i).Tag = SquTag
                .Square(i).WhatsThisHelpID = SquWha
            Next
            'Now load the image pieces on the board.

            Input #FileNum, imgCnt
            For i = 0 To imgCnt - 1
                Input #FileNum, InpStr
                SquTag = Left(InpStr, 1)
                SquWha = Mid(InpStr, 2, 1)
                ImgTag = Mid(InpStr, 3)
                For x = 0 To .Square.Count - 1
                    If .Square(x).Tag = SquTag And _
                    .Square(x).WhatsThisHelpID = SquWha Then
                        For j = 0 To .imgPiece.Count - 1
                            If .imgPiece(j).Tag = ImgTag Then
                                .Square(x).Picture = .imgPiece(j).Picture
                            End If
                        Next
                    End If
                Next
            Next
        Close
    End With
    Exit Sub
    
handleit:
    MsgBox "This file was not found.", vbExclamation, "Error"
End Sub

Private Sub SaveGame()
    Dim i As Integer
    Dim x As Integer
    Dim FileNum As Long
    Dim strImgTag As String
    Dim HowManyImg As Integer
    Dim YourMove As String
    
    YourMove = InputBox("Is the next move yours? Enter 'y' for Yes and 'n' for No.", "Save Turn")
    If YourMove <> "y" And YourMove <> "n" Then
        MsgBox "Response not understood, please enter proper parameters.", vbExclamation, "Game Not Yet Saved"
        Exit Sub
    End If
    With frmChessBoard
        'First off, save all letters and the numbers on
        'the sides of the board because these change
        'depending on the colour that you are.
        With .CommonDialog1
            .Filter = "Net Chess Saved Games (*.CHS)|*.CHS"
            .DialogTitle = "Save current game"
            .InitDir = App.Path
            .ShowSave
            If .FileName = "" Then Exit Sub
        End With
        FileNum = FreeFile
        Open .CommonDialog1.FileName For Output As FileNum
            'Save who's turn it is.
            
            Print #FileNum, YourMove
            'Print out chessboard letter positions.
            For i = 0 To .lblLetter.Count - 1
                Print #FileNum, .lblLetter(i).Caption
            Next
            For i = 0 To .lblLeftNum.Count - 1
                Print #FileNum, .lblLeftNum(i).Caption
            Next
            'Print out all squares and their tag names and
            'their WhatsThisHelpID's.
            For i = 0 To .Square.Count - 1
                Print #FileNum, .Square(i).Tag & .Square(i).WhatsThisHelpID
            Next
            'First find out how many images are on the board.
            HowManyImg = 0
            For i = 0 To .Square.Count - 1
                If .Square(i).Picture <> 0 Then
                    HowManyImg = HowManyImg + 1
                End If
            Next
            Print #FileNum, HowManyImg
            'Now print out the positions of the pieces on the
            'board so you know where the pieces are.
            For i = 0 To .Square.Count - 1
                If .Square(i).Picture <> 0 Then
                    For x = 0 To .imgPiece.Count - 1
                        If .Square(i).Picture = .imgPiece(x).Picture Then
                            Print #FileNum, .Square(i).Tag & .Square(i).WhatsThisHelpID & .imgPiece(x).Tag
                            Exit For
                        End If
                    Next
                End If
            Next
        Close
    End With
    MsgBox "This chess game has been saved. You may resume it at a later stage.", vbInformation, "Game Saved"
End Sub

Public Sub Load()
    LoadGame
End Sub

Public Sub Save()
    SaveGame
End Sub
