VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsServerConnect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private strPort As String

Public Property Get PortAddress() As String
    PortAddress = strPort
End Property

Public Property Let PortAddress(ByVal NewValue As String)
    strPort = NewValue
End Property

Public Sub Connect()
    ConnectNow
End Sub

Public Sub ConnectionRequest(requestID As Long)
    RequestMadeForConnection (requestID)
End Sub

Public Sub Disconnect()
    DisconnectNow
End Sub

Private Sub ConnectNow()
    On Error GoTo ConnectError
    With frmChessBoard
        'If fine then connect now.
        If Trim(.txtPort) = "" Or Not IsNumeric(.txtPort) Then
            MsgBox "Port Incorrect", , "Error"
            Exit Sub
        End If
        .sckConnection.LocalPort = CInt(Trim(.txtPort))
        .sckConnection.Listen
        
        .lblConnectResult = "Invitation now open..."
        .cmdCancel.Enabled = True
        .cmdInvite.Enabled = False
        Exit Sub
ConnectError:
        .lblConnectResult = Err.Number & " A connection error has occured..."
    End With
End Sub

Private Sub RequestMadeForConnection(requestID As Long)
    With frmChessBoard
        'If you're already involved in a game, reject the request.
        If .sckConnection.State = sckConnected Then Exit Sub
        'Connect.
        If .sckConnection.State <> sckClosed Then .sckConnection.Close
        .sckConnection.Accept requestID
        
        'Show applicable controls.
        .fraConnect.Visible = False
        .fraCommunicate.Visible = True
        .rtbChat.SelColor = vbRed
        .rtbChat.SelBold = False
        .rtbChat.SelItalic = True
        
        .mnuBlack.Enabled = True
        .mnuWhite.Enabled = True
        .mnuDisconnect.Enabled = True
        .mnuCreate.Enabled = True
        .rtbChat.SelText = "CONNECTED NOW..."
        .txtMessage.SetFocus
    End With
End Sub

Private Sub DisconnectNow()
    With frmChessBoard
        .sckConnection.Close
        'Show applicable controls.
        .rtbChat.SelColor = vbRed
        .rtbChat.SelBold = False
        .rtbChat.SelItalic = True
        
        .mnuBlack.Enabled = False
        .mnuWhite.Enabled = False
        .mnuDisconnect.Enabled = False
        .mnuCreate.Enabled = False
        .rtbChat.SelText = "DISCONNECTED..."
        .cmdSend.Enabled = False
        .cmdMove.Enabled = False
    End With
End Sub
